/*
 * Decompiled with CFR 0.152.
 */
package frc.util.xml;

import frc.util.xml.XMLLoaderContext;
import java.text.DateFormat;
import java.util.Date;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLLoaderHandler
implements ContentHandler {
    protected static final boolean DEBUG = false;
    private final XMLLoaderContext<?> ctx;
    private final XMLLoaderHandler parent;

    public XMLLoaderHandler(XMLLoaderContext<?> xMLLoaderContext) {
        this.parent = null;
        this.ctx = xMLLoaderContext;
    }

    public XMLLoaderHandler(XMLLoaderHandler xMLLoaderHandler) {
        this.parent = xMLLoaderHandler;
        this.ctx = xMLLoaderHandler.getContext();
    }

    protected String getDebugLabel() {
        return null;
    }

    protected int getLine() {
        Locator locator = this.getContext().getLocator();
        return locator == null ? -1 : locator.getLineNumber();
    }

    protected String getLineString() {
        int n = this.getLine();
        return n < 0 ? "" : " at line " + n;
    }

    public void pushed(Attributes attributes) {
    }

    public void poped() {
    }

    public XMLLoaderHandler getParent() {
        return this.parent;
    }

    public XMLLoaderContext<?> getContext() {
        return this.ctx;
    }

    public XMLLoaderHandler getChildHandler(String string, Attributes attributes) {
        return this.ctx.getDefaultHandler();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.ctx.setLocator(locator);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.ctx.pop();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.ctx.push(this.getChildHandler(string3, attributes), attributes);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public static int clamp(int n, int n2, int n3) {
        return Math.min(n3, Math.max(n2, n));
    }

    public static boolean hasAttribute(Attributes attributes, String string) {
        return attributes.getValue(string) != null;
    }

    public static String getAttribute(Attributes attributes, String string, String string2) {
        String string3 = attributes.getValue(string);
        return string3 == null ? string2 : string3;
    }

    public static float getAttribute(Attributes attributes, String string, float f) throws NumberFormatException {
        return Math.max(f, Float.parseFloat(attributes.getValue(string)));
    }

    public static Date loadDate(Attributes attributes, String string, DateFormat dateFormat, Date date) {
        String string2 = XMLLoaderHandler.getAttribute(attributes, string, null);
        if (string2 != null) {
            try {
                return dateFormat.parse(string2);
            }
            catch (Exception exception) {}
        }
        return date;
    }

    public static int loadInt(Attributes attributes, String string, int n) {
        String string2 = XMLLoaderHandler.getAttribute(attributes, string, null);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n;
    }

    public static int loadInt(Attributes attributes, String string, int n, int n2, int n3) {
        return XMLLoaderHandler.clamp(XMLLoaderHandler.loadInt(attributes, string, n), n2, n3);
    }

    public static long loadLong(Attributes attributes, String string, long l) {
        String string2 = XMLLoaderHandler.getAttribute(attributes, string, null);
        if (string2 != null) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return l;
    }

    public static long loadLong(Attributes attributes, String string, long l, long l2, long l3) {
        return Math.min(l3, Math.max(l2, XMLLoaderHandler.loadLong(attributes, string, l)));
    }

    public static float loadFloat(Attributes attributes, String string, float f) {
        String string2 = XMLLoaderHandler.getAttribute(attributes, string, null);
        if (string2 != null) {
            try {
                return Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return f;
    }

    public static float loadFloat(Attributes attributes, String string, float f, float f2, float f3) {
        return Math.min(f3, Math.max(f2, XMLLoaderHandler.loadFloat(attributes, string, f)));
    }

    public static Float loadFloat(Attributes attributes, String string, float f, float f2) {
        assert (f != Float.MIN_VALUE);
        float f3 = XMLLoaderHandler.loadFloat(attributes, string, Float.MIN_VALUE, f, f2);
        return Float.MIN_VALUE == f3 ? null : new Float(f3);
    }

    public static boolean loadBool(Attributes attributes, String string, boolean bl) {
        String string2 = XMLLoaderHandler.getAttribute(attributes, string, null);
        return string2 == null ? bl : string2.equalsIgnoreCase("true");
    }

    public static boolean loadOnOff(Attributes attributes, String string, boolean bl) {
        String string2 = XMLLoaderHandler.getAttribute(attributes, string, null);
        return string2 == null ? bl : string2.equalsIgnoreCase("on");
    }

    public static String loadStr(Attributes attributes, String string, String string2) {
        String string3 = XMLLoaderHandler.getAttribute(attributes, string, null);
        return string3 == null ? string2 : string3;
    }
}

